/*
 * Decompiled with CFR 0.152.
 */
package ags.ui;

import ags.communication.DataUtil;
import ags.communication.TransferHost;
import ags.controller.Configurable;
import ags.ui.IVirtualScreen;
import ags.ui.TextScreen40;
import ags.ui.Util;
import ags.ui.graphics.HGRImage;
import ags.ui.host.Style;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HiresScreen
implements IVirtualScreen {
    public static BufferedImage screen = new BufferedImage(560, 192, 1);
    private HGRImage appleScreen = new HGRImage();
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=false)
    public static Style.FONT DISPLAY_FONT = Style.FONT.APPLE2FAT;
    public static FontMetrics appleFontMetrics;
    public static int CHARACTER_WIDTH;
    public static int CHARACTER_HEIGHT;
    String spaces = Util.repeat(' ', 40);
    private boolean changed;
    private boolean alreadyActive = false;
    byte[] lastScreen = new byte[8192];
    boolean stale = true;

    public static void setCurrentFont(Style.FONT newFont) {
        DISPLAY_FONT = newFont;
        appleFontMetrics = screen.getGraphics().getFontMetrics(HiresScreen.DISPLAY_FONT.font);
    }

    public HiresScreen() {
        HiresScreen.setCurrentFont(DISPLAY_FONT);
        this.clear();
    }

    public BufferedImage getScreen() {
        return screen;
    }

    public void clear() {
        this.changed = true;
        Graphics g = screen.getGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, screen.getWidth(), screen.getHeight());
    }

    public void drawText(int x, int y, String text, boolean invert) {
        this.changed = true;
        if (y < 0 || y > 23) {
            return;
        }
        int xx = x * CHARACTER_WIDTH;
        int yy = y * CHARACTER_HEIGHT;
        Rectangle2D size = appleFontMetrics.getStringBounds(text, screen.getGraphics());
        BufferedImage textImg = new BufferedImage((int)size.getWidth(), (int)(size.getHeight() * (double)HiresScreen.DISPLAY_FONT.heightAdjust), 2);
        Graphics g = textImg.getGraphics();
        g.setFont(HiresScreen.DISPLAY_FONT.font);
        if (invert) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, (int)size.getWidth(), (int)size.getHeight());
        }
        g.setColor(!invert ? Color.WHITE : Color.BLACK);
        g.drawString(text, 0, (int)((float)appleFontMetrics.getAscent() * HiresScreen.DISPLAY_FONT.heightAdjust));
        if (HiresScreen.DISPLAY_FONT.isFat) {
            g.drawString(text, 1, (int)((float)appleFontMetrics.getAscent() * HiresScreen.DISPLAY_FONT.heightAdjust));
        }
        this.drawImage(x, y, x + text.length(), y + 1, textImg);
    }

    public void drawBox(int x1, int y1, int x2, int y2, boolean invert) {
        this.changed = true;
        Graphics g = screen.getGraphics();
        int xx1 = x1 * CHARACTER_WIDTH;
        int yy1 = y1 * CHARACTER_HEIGHT;
        int xx2 = (x2 + 1) * CHARACTER_WIDTH;
        int yy2 = (y2 + 1) * CHARACTER_HEIGHT;
        g.setColor(invert ? Color.WHITE : Color.BLACK);
        g.fillRect(xx1, yy1, xx2 - xx1, yy2 - yy1);
    }

    public void drawBorder(int x1, int y1, int x2, int y2, boolean invert) {
        this.changed = true;
        Graphics g = screen.getGraphics();
        int xx1 = (x1 - 1) * CHARACTER_WIDTH;
        int yy1 = (y1 - 1) * CHARACTER_HEIGHT;
        int xx2 = (x2 + 2) * CHARACTER_WIDTH - 1;
        int yy2 = (y2 + 2) * CHARACTER_HEIGHT - 1;
        g.setColor(Color.BLACK);
        g.fillRect(xx1, yy1, CHARACTER_WIDTH - 1, yy2 - yy1);
        g.fillRect(xx2 - CHARACTER_WIDTH + 1, yy1, CHARACTER_WIDTH - 1, yy2 - yy1);
        g.fillRect(xx1, yy1, xx2 - xx1, CHARACTER_HEIGHT - 1);
        g.fillRect(xx1, yy2 - CHARACTER_HEIGHT + 1, xx2 - xx1, CHARACTER_HEIGHT - 1);
        if (invert) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(Color.BLUE);
        }
        for (int ix = 0; ix < CHARACTER_WIDTH; ++ix) {
            if (ix == 4) {
                if (invert) {
                    g.setColor(Color.BLUE);
                } else {
                    g.setColor(Color.BLACK);
                }
            }
            int iy = (int)((double)ix * ((double)CHARACTER_HEIGHT / (double)CHARACTER_WIDTH));
            g.drawRect(xx1 + ix, yy1 + iy, xx2 - xx1 - ix * 2, yy2 - yy1 - iy * 2);
        }
        g.setColor(Color.BLACK);
        int cornerWidth = CHARACTER_WIDTH / 4;
        g.fillRect(xx1, yy1, cornerWidth, 1);
        g.fillRect(xx1, yy2, cornerWidth, 1);
        g.fillRect(xx2 - cornerWidth + 1, yy1, cornerWidth, 1);
        g.fillRect(xx2 - cornerWidth + 1, yy2, cornerWidth, 1);
    }

    public void drawCursor(int x, int y) {
        this.changed = true;
        this.drawText(x, y, ">", true);
    }

    public void drawImage(int x, int y, int x1, int y1, Image i) {
        this.changed = true;
        screen.getGraphics().drawImage(i, x * CHARACTER_WIDTH, y * CHARACTER_HEIGHT, (x1 - x) * CHARACTER_WIDTH, (y1 - y) * CHARACTER_HEIGHT, null);
    }

    public byte[] getBuffer() {
        try {
            if (this.changed) {
                this.appleScreen.convertColorImage(screen);
            }
            this.changed = false;
            return this.appleScreen.getAppleImage();
        }
        catch (IOException ex) {
            Logger.getLogger(HiresScreen.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public int getDisplayOffset() {
        return 8192;
    }

    protected void copyScreen() {
        byte[] buffer = this.getBuffer();
        for (int i = 0; i < buffer.length; ++i) {
            this.lastScreen[i] = buffer[i];
        }
    }

    public void send(TransferHost host) {
        byte[] buffer = this.getBuffer();
        try {
            if (this.stale) {
                host.sendRawData(buffer, this.getDisplayOffset(), 0, buffer.length);
            } else {
                byte[] send = DataUtil.packScreenUpdate(this.getDisplayOffset(), this.lastScreen, buffer);
                host.sendCompressedData(send);
            }
            this.stale = false;
            this.copyScreen();
        }
        catch (IOException ex) {
            Logger.getLogger(TextScreen40.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.activate(host);
    }

    public void activate(TransferHost host) {
        if (this.alreadyActive) {
            return;
        }
        this.alreadyActive = true;
        try {
            host.toggleSwitch(49234);
            host.toggleSwitch(49232);
            host.toggleSwitch(49239);
            host.toggleSwitch(49236);
            host.toggleSwitch(49164);
        }
        catch (IOException ex) {
            Logger.getLogger(HiresScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        CHARACTER_WIDTH = 14;
        CHARACTER_HEIGHT = 8;
    }
}

